/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.network;

import com.gizmo.luggage.entity.LuggageEntity;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CallLuggagePetsPacket {
    private final int playerId;

    public CallLuggagePetsPacket(int playerId) {
        this.playerId = playerId;
    }

    public CallLuggagePetsPacket(FriendlyByteBuf buf) {
        this.playerId = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.playerId);
    }

    public static class Handler {
        public static void onMessage(CallLuggagePetsPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    player.m_183503_().m_8583_().forEach(luggageIHope -> {
                        LuggageEntity luggage;
                        if (luggageIHope instanceof LuggageEntity && (luggage = (LuggageEntity)((Object)((Object)luggageIHope))).m_142480_() != null && luggage.m_142480_().m_7306_(Objects.requireNonNull(player.m_183503_().m_6815_(message.playerId)))) {
                            luggage.m_8127_();
                            luggage.m_20219_(player.m_20182_());
                            if (luggage.isTryingToFetchItem()) {
                                luggage.setTryingToFetchItem(false);
                            }
                            luggage.setFetchCooldown(200);
                            luggage.m_21837_(false);
                        }
                    });
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

